//
//  ViewController.swift
//  SSO TVE Tester (tvOS)
//
//  Copyright © 2016 Apple, Inc. All rights reserved.
//

import UIKit

class ViewController: UIViewController, UITableViewDelegate, UITableViewDataSource, AMPresenter {

    @IBOutlet weak var menu: UITableView!
    @IBOutlet weak var logs: UITextView!
    
    var authManager : AuthManager?
    var log : [String] = []
    
    override func viewDidLoad() {
        super.viewDidLoad()
        // Do any additional setup after loading the view, typically from a nib.
        
        authManager = AuthManager(self)
        if #available(tvOS 13.0, *) {
            switch traitCollection.userInterfaceStyle {
                case .light:
                    self.overrideUserInterfaceStyle = .light
                case .dark:
                    self.overrideUserInterfaceStyle = .dark
                case .unspecified:
                    break
            default:
                break
            }
            
        } 
        if let logs = self.logs {
            logs.layer.borderWidth = 1.0
            logs.layer.borderColor = UIColor.gray.cgColor
            logs.layer.cornerRadius = 5
            logs.isSelectable = true
            logs.panGestureRecognizer.allowedTouchTypes = [(UITouch.TouchType.indirect.rawValue) as NSNumber]
        }
    }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }

    // MARK: - Table View
    
    func numberOfSections(in tableView: UITableView) -> Int {
        return 1
    }
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return MenuItems.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withIdentifier: "Cell", for: indexPath)
        
        let object = MenuItems[indexPath.row]
        cell.textLabel!.text = object.label
        
        return cell
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        let object = MenuItems[indexPath.row]
        object.action(authManager!)
    }
    
    // MARK: AM Presenter
    
    func presentMessage(_ title: String, message: String) {
        let newMessage = "\(title): \(message)"
        print(newMessage)
        
        DispatchQueue.main.async {
            self.appendLog(newMessage)
        }
    }
    
    func presentViewController(_ viewController: UIViewController) {
        DispatchQueue.main.async {
            self.present(viewController, animated: true, completion: nil)
        }
    }
    
    func dismissViewController(_ viewController: UIViewController) {
        DispatchQueue.main.async {
            self.dismiss(animated: true, completion: nil)
        }
    }
    
    // MARK: Internal
    
    @IBAction func clearLogs(_ sender: AnyObject) {
        logs.text = ""
        log.removeAll()
    }
    
    func appendLog(_ message : String) {
        log.append(message)
        if let logs = self.logs {
            logs.text = log.joined(separator: "\n")
        }
    }
}

