//
//  DetailViewController.swift
//  SSO TVE Tester
//
//  Copyright © 2016 Apple, Inc. All rights reserved.
//

import UIKit

class DetailViewController: UIViewController {

    @IBOutlet weak var detailDescriptionLabel: UILabel!

    @IBOutlet weak var logs: UITextView!
    var log : [String] = []

    func configureView() {
        // Update the user interface for the detail item.
        if let detail = self.detailItem {
            if let label = self.detailDescriptionLabel {
                label.text = detail.description
            }
        }
    }

    override func viewDidLoad() {
        super.viewDidLoad()
        // Do any additional setup after loading the view, typically from a nib.
        self.configureView()
        if let logs = self.logs {
            logs.layer.borderWidth = 1.0
            logs.layer.cornerRadius = 10
            
            logs.text = log.joined(separator: "\n")
        }
        if #available(iOS 13.0, *) {
            switch self.traitCollection.userInterfaceStyle {
                case .light:
                    self.overrideUserInterfaceStyle = .light
                    logs.layer.borderColor = UIColor.darkGray.cgColor
                case .dark:
                    self.overrideUserInterfaceStyle = .dark
                    logs.layer.backgroundColor = UIColor.systemGray.cgColor
                case .unspecified:
                    break
            default:
                break
            }
        }
    }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }

    var detailItem: NSDate? {
        didSet {
            // Update the view.
            self.configureView()
        }
    }

    @IBAction func clearLogs(_ sender: AnyObject) {
        logs.text = ""
        log.removeAll()
    }

    func appendLog(_ message : String) {
        log.append(message)
        if let logs = self.logs {
            logs.text = log.joined(separator: "\n")
        }
    }
    
}

