//
//  Utilities.swift
//  AppleTVE
//
//  Copyright © 2016 Apple, Inc. All rights reserved.
//

import Foundation
import VideoSubscriberAccount

extension String {
    func format(_ args: CVarArg...) -> String {
        return  String(format: self, arguments: args)
    }
}


let MenuItems : Array<(label: String, action:(AuthManager) -> Swift.Void)> = [
    ("SSO Access Status", { (manager) in manager.accessCheck(false) }),
    ("SSO Access Request", { (manager) in manager.accessCheck(true) }),
    ("SSO Authentication Status", { (manager) in manager.authenticationCheck(false, completionHandler: {(status) in
        print("Authentication check: \(status)")
    }) }),
    ("AuthN Status", { (manager) in manager.localAuthCheck() }),
    ("AuthN Request", { (manager) in manager.accountMetadata() }),
    ("AuthZ Status", { (manager) in manager.authorizationCheck() }),
    ("AuthZ Request", { (manager) in manager.authorizationRequest() }),
    ("Authentication Share", { (manager) in manager.authenticationShare(completionHandler: {(status) in
        print("Authentication Share check: \(status)")
    }) }),
    ("Clear App Storage", { (manager) in manager.clearAppStorage() }),
    ("Open App Settings", { (manager) in manager.openSettings() })
]


let AuthTokenCharacterSet = CharacterSet(charactersIn: "=\"#%/<>?@\\^`{|}")
let Storage : UserDefaults = UserDefaults.standard

let VSAAccessTitle = "VSA Access Status"
let AccessMessage : [VSAccountAccessStatus:String] = [
    VSAccountAccessStatus.notDetermined : "Not Determined",
    VSAccountAccessStatus.restricted : "Restricted",
    VSAccountAccessStatus.denied : "Denied",
    VSAccountAccessStatus.granted : "Granted"
]


enum AuthorizationStatus: String {
    case undefined
    case denied
    case granted
}


struct RequestProperties {
    static let identifier = "https://usg1.apple.com/saml-sp/module.php/saml/sp/metadata.php/Apple-SSO-SP"
    static let attributes = ["client_id", "internal_id", "entity_type", "mvpd_uuid", "mvpd_hhid", "is_hoh"]
}


struct StorageKeys {
    static let accountIdentifier = "accountProviderIdentifier"
    static let loggedIn = "userLoggedIn"
    static let expirationDate = "authenticationExpirationDate"
    static let token = "authToken"
    static let userMetadata = "samlAttributeQueryResponse"
    static let authorizationStatus = "authZStatus"
}


struct Endpoints {
    static let verificationToken = "https://yourserver/SP/verificationToken?providerID="
    static let authentication = "https://yourserver/SP/authN"
    static let authorization = "https://yourserver/SP/authZ"
}


struct Messages {
    static let noMessage = "Message didn't get set"
    static let notAuthenticated = "User is not authenticated"
    static let authenticationCheck = "User is logged in with %@ \n\nSSO Authentication Expiration: \n%@"
    static let authenticationTitle = "%@ Authentication Status"
    static let clearAppStorageTitle = "Clear Application Storage"
    static let clearAppStorageMessage = "Success"
    static let userMetadataRequest = "Request User Metadata"
    static let authenticationTokenMessage = "Local authentication successfully received."
    static let authenticationTokenTitle = "Retrieving Local Token"
    static let verificationTokenTitle = "Verification Token Request"
    static let verificationTokenMessage = "Verification Token successfully received %@"
    static let authorizationStatusTitle = "Authorization Status"
    static let authorizationSuccess = "Success"
    static let authorizationFail = "Fail"
    static let authenticationExpired = "Expired"
    static let authenticationUnset = "No Authentication Token"
    static let unsupportedProviderTitle = "Unsupported TV Provider"
    static let unsupportedProviderMessage = "%@ is not in the supported TV Provider list."
}
