//-------------------------------------------------------------------------------------------------------------------------------------------------------------
//
// Copyright 2023 Apple Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
//-------------------------------------------------------------------------------------------------------------------------------------------------------------


//-------------------------------------------------------------------------------------------------------------------------------------------------------------
// This project includes a pre-compiled version of this file.
// In order to modify it, you need to build the DirectX
// Shader Compiler. Please see the README for instructions.
//-------------------------------------------------------------------------------------------------------------------------------------------------------------


struct CameraData
{
    float4x4 perspectiveTransform;
};

ConstantBuffer<CameraData> cameraData : register(b0, space0);

struct VertexIn
{
    float4 position : POSITION;
};

struct v2f
{
    float4 position : SV_Position;
    float3 color : COLOR;
};

v2f MainVS( VertexIn vin )
{
    v2f o = (v2f)0;
    o.position = mul( cameraData.perspectiveTransform, vin.position );
    o.color = float3(0.0, 0.45, 0.0);
    return o;
}

float4 MainFS( v2f vin ) : SV_Target
{
    return float4(vin.color, 1.0);
}
