//-------------------------------------------------------------------------------------------------------------------------------------------------------------
//
// Copyright 2023 Apple Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
//-------------------------------------------------------------------------------------------------------------------------------------------------------------

#import <Cocoa/Cocoa.h>
#import <Metal/Metal.h>
#import <MetalKit/MetalKit.h>

// The macOS view controller.
@interface GameViewController : NSViewController <NSWindowDelegate>

@property (nonatomic, weak) IBOutlet NSView* configBackdrop;
@property (nonatomic, weak) IBOutlet NSSegmentedControl* renderModeControl;
@property (nonatomic, weak) IBOutlet NSProgressIndicator* progressIndicator;

@property (nonatomic, weak) IBOutlet NSSlider* animationFactorSlider;
@property (nonatomic, weak) IBOutlet NSButton* indexedDrawToggle;

@property (nonatomic, weak) IBOutlet NSView* tessellationInnerSliderLabel;
@property (nonatomic, weak) IBOutlet NSSlider* tessellationInnerSlider;

- (IBAction)onRenderModeSegmentedControlAction:(id)sender;
- (IBAction)onCheckboxToggledAction:(id)sender;
- (IBAction)onAnimationSpeedSliderValueChanged:(id)sender;
- (IBAction)onInnerTessellationSliderValueChanged:(id)sender;

@end
